import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil
import com.liferay.portal.service.UserLocalServiceUtil
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil
import com.liferay.portal.util.PortalUtil
import com.liferay.portlet.journal.service.permission.JournalFolderPermission
import com.liferay.portlet.journal.model.JournalArticle
import com.liferay.portal.kernel.workflow.WorkflowConstants

def screenName = "ses54586"
def groupId = 381376
def articleId = "2252297"

user = UserLocalServiceUtil.fetchUserByScreenName(PortalUtil.getDefaultCompanyId(), screenName)
out.println("User: " + user.getFullName())

article = JournalArticleLocalServiceUtil.fetchDisplayArticle(groupId, articleId)
out.println("Article: " + article.getTitle(user.getLocale()) + " v" + article.getVersion() + " (" + WorkflowConstants.getStatusLabel(article.getStatus()) + ")")

permissionChecker = PermissionCheckerFactoryUtil.create(user)
out.println("User can VIEW article? " + permissionChecker.hasPermission(article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), "VIEW"))
out.println("User can UPDATE article? " + permissionChecker.hasPermission(article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), "UPDATE"))
out.println("User can VIEW article as owner? " + permissionChecker.hasOwnerPermission(article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), user.getUserId(), "VIEW"))

folder = article.getFolder();
out.println("Folder: " + folder.getName())

out.println("User can ACCESS folder? " + JournalFolderPermission.contains(permissionChecker, folder, "ACCESS"))
out.println("User can VIEW folder? " + JournalFolderPermission.contains(permissionChecker, folder, "VIEW"))